import type { CrudSchema } from '@/hooks/web/useCrudSchemas'
import { dateFormatter, dateFormatter2 } from '@/utils/formatTime'
import { DICT_TYPE } from '@/utils/dict'
const { t } = useI18n() // 国际化

// CrudSchema：https://doc.iocoder.cn/vue3/crud-schema/
const crudSchemas = reactive<CrudSchema[]>([
    {
        label: '所属员工',
        field: 'staffCode',
        table: {
            width: 120
        },
        isSearch: false
    },

    {
        label: '体检日期',
        field: 'checkDate',
        formatter: dateFormatter2,
        detail: {
            dateFormat: 'YYYY-MM-DD'
        },
        table: {
            width: 120
        }
    },

    {
        label: '有无所从事职业禁忌',
        field: 'jobTaboo',
        dictType: DICT_TYPE.SYSTEM_JOBTABOO,
        table: {
            width: 120
        },
        isSearch: false
    },
    {
        label: '职业禁忌',
        field: 'jobTabooDesc',
        table: {
            width: 120
        },
        isSearch: false
    },

    {
        label: '能否从事此项工作',
        field: 'jobCapable',
        dictType: DICT_TYPE.SYSTEM_JOBCAPABLE,
        table: {
            width: 120
        },
        isSearch: false
    },

    {
        label: '体检报告',
        field: 'file',
        table: {
            width: 120
        },
        isSearch: false
    },

    {
        label: '创建时间',
        field: 'createTime',
        formatter: dateFormatter2,
        detail: {
            dateFormat: 'YYYY-MM-DD'
        },
        table: {
            width: 120
        }
    }
])
export const { allSchemas } = useCrudSchemas(crudSchemas)
